/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.config.Configurable;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Computer;
import jace.core.RAMEvent;
import jace.hardware.DiskIIDrive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardDiskII
extends Card
implements Reconfigurable {
    @Configurable(name="Disk 1")
    public File disk1;
    @Configurable(name="Disk 2")
    public File disk2;
    DiskIIDrive currentDrive;
    DiskIIDrive drive1;
    DiskIIDrive drive2;

    public CardDiskII() {
        try {
            this.loadRom("jace/data/DiskII.rom");
        }
        catch (IOException ex) {
            Logger.getLogger(CardDiskII.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.drive1 = new DiskIIDrive();
        this.drive2 = new DiskIIDrive();
        this.reset();
    }

    public void reset() {
        this.currentDrive = this.drive1;
        this.drive1.reset();
        this.drive2.reset();
    }

    protected void registerCustomListeners() {
    }

    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        switch (register) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.currentDrive.step(register);
                break;
            }
            case 8: {
                this.currentDrive.setOn(false);
                this.tweakTiming();
                break;
            }
            case 9: {
                this.currentDrive.setOn(true);
                this.tweakTiming();
                break;
            }
            case 10: {
                this.currentDrive = this.drive1;
                break;
            }
            case 11: {
                this.currentDrive = this.drive2;
                break;
            }
            case 12: {
                this.currentDrive.write();
                e.setNewValue(this.currentDrive.readLatch());
                break;
            }
            case 15: {
                this.currentDrive.setWriteMode();
            }
            case 13: {
                if (e.getType() == RAMEvent.TYPE.WRITE) {
                    this.currentDrive.setLatchValue((byte)e.getNewValue());
                }
                e.setNewValue(this.currentDrive.readLatch());
                break;
            }
            case 14: {
                this.currentDrive.setReadMode();
                if (this.currentDrive.disk != null && this.currentDrive.disk.writeProtected) {
                    e.setNewValue(128);
                    break;
                }
                e.setNewValue(0);
            }
        }
    }

    public void loadRom(String path) throws IOException {
        InputStream romFile = CardDiskII.class.getClassLoader().getResourceAsStream(path);
        int cxRomLength = 256;
        byte[] romData = new byte[256];
        if (romFile.read(romData) != 256) {
            throw new IOException("Bad Disk ][ ROM size");
        }
        this.getCxRom().loadData(romData);
    }

    public void motherboardTick() {
    }

    public void reconfigure() {
        try {
            if (this.disk1 == null) {
                this.drive1.ejectDisk();
            } else {
                this.drive1.insertDisk(this.disk1);
            }
            if (this.disk2 == null) {
                this.drive2.ejectDisk();
            } else {
                this.drive2.insertDisk(this.disk2);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CardDiskII.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void tweakTiming() {
        if (this.drive1.isOn() || this.drive2.isOn()) {
            Computer.getComputer().requestSpeed(this);
        } else {
            Computer.getComputer().cancelSpeedRequest(this);
        }
    }
}

